/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.mixin.common;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"net.minecraft.world.entity.LivingEntity.onClimbable"}, at={@At(value="HEAD")}, cancellable=true)
    public void onClimbable(CallbackInfoReturnable<Boolean> cir) {
        cir.cancel();
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_5833_()) {
            cir.setReturnValue((Object)false);
        } else {
            BlockPos blockpos = entity.m_20183_();
            BlockState blockstate = this.m_146900_();
            cir.setReturnValue((Object)this.isLivingOnLadder(blockstate, entity.f_19853_, blockpos, entity));
        }
    }

    public boolean isLivingOnLadder(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof Player && entity.m_5833_();
        if (isSpectator) {
            return false;
        }
        if (!((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            return this.isLadder(state, (LevelAccessor)world, pos, entity);
        }
        AABB bb = entity.m_20191_();
        int mX = Mth.m_14107_((double)bb.f_82288_);
        int mY = Mth.m_14107_((double)bb.f_82289_);
        int mZ = Mth.m_14107_((double)bb.f_82290_);
        int y2 = mY;
        while ((double)y2 < bb.f_82292_) {
            int x2 = mX;
            while ((double)x2 < bb.f_82291_) {
                int z2 = mZ;
                while ((double)z2 < bb.f_82293_) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    if (!world.m_46749_(pos)) {
                        return false;
                    }
                    state = world.m_8055_(tmp);
                    if (this.isLadder(state, (LevelAccessor)world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    private boolean isLadder(BlockState state, LevelAccessor world, BlockPos pos, LivingEntity entity) {
        Block block = state.m_60734_();
        if (block instanceof CrossCollisionBlock) {
            int zCount = 0;
            int xCount = 0;
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52309_)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52311_)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52310_)).booleanValue()) {
                ++xCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52312_)).booleanValue()) {
                ++xCount;
            }
            return zCount + xCount <= 1 || zCount == 1 && xCount == 1;
        }
        if (block instanceof RotatedPillarBlock) {
            return ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)).m_122478_();
        }
        if (block instanceof EndRodBlock) {
            Direction direction = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
            return direction == Direction.UP || direction == Direction.DOWN;
        }
        return block.isLadder(state, (LevelReader)world, pos, entity);
    }
}

